import os
import sys

import infra.callisto.deploy.resource as deploy_resource

import infra.callisto.deploy.storage.storage as storage
import utils


class ArgsMode(object):
    @staticmethod
    def add_args(parser):
        parser.add_argument('--storage-root', help='path to storage root', required=True)
        parser.add_argument('--namespace_prefix', help='namespace prefix', required=True)
        parser.add_argument('--tier', help='tier name', required=True)
        parser.add_argument('--generation', help='base generation', required=True, type=int)
        parser.add_argument('--shard', help='shard name', required=True)

    @staticmethod
    def resolve(args):
        sys.stderr.write('called with: [{}]\n'.format(' '.join(sys.argv[1:])))

        namespace = deploy_resource.safe_join_path(args.namespace_prefix, str(args.generation), args.tier)
        print eval_path(args.storage_root, namespace, args.shard)


class EnvMode(object):
    @staticmethod
    def add_args(parser):
        parser.add_argument('--storage-root', help='path to storage root', required=True)

    @staticmethod
    def resolve(args):
        namespace_prefix = os.environ['NAMESPACE_PREFIX']
        generation = os.environ['DB_TIMESTAMP']
        tier = utils.get_tier()
        shard = _eval_shard_name(utils.get_shard(), generation)

        _dump_args(
            storage_root=args.storage_root,
            namespace_prefix=namespace_prefix,
            generation=generation,
            tier=tier,
            shard=shard,
        )

        namespace = deploy_resource.safe_join_path(namespace_prefix, generation, tier)
        print eval_path(args.storage_root, namespace, shard)


def _eval_shard_name(shard_template, generation):
    return shard_template.replace('0000000000', '{:010}'.format(int(generation)))


def _dump_args(**kwargs):
    lines = ['{}={}'.format(key, value) for key, value in kwargs.items()]
    sys.stderr.write('called with:\n' + '\n'.join(lines) + '\n')


def eval_path(storage_root, namespace, shard_name):
    return storage.resource_path(
        storage_root,
        namespace,
        shard_name,
    )
