import basesearch


def get_search_class(itype, metaprj):
    return _TAGS_TO_CLASS.get((itype, metaprj)) or _TAGS_TO_CLASS[(itype, )]


_TAGS_TO_CLASS = {
    ('mmeta', 'imgs'): basesearch.ImgMiddlesearch,
    ('rtyserver', 'imgs'): basesearch.ImgQuickRtyServer,

    ('mmeta', 'video'): basesearch.VideoMiddlesearch,
    ('rtyserver', 'video'): basesearch.VideoQuickRtyServer,

    ('mmeta', 'saas'): basesearch.RefreshMiddlesearch,
    ('fusion', 'saas'): basesearch.RefreshRtyServer,

    ('rtyserver', 'saas'): basesearch.NewsQuickRtyServer,

    ('mmeta', 'mmeta-yp'): basesearch.MiddlesearchYP,

    ('mmeta', ): basesearch.Middlesearch,
    ('intl2', ): basesearch.IntSearch,
    ('int', ): basesearch.IntSearch,
    ('int', 'web'): basesearch.IntSearchRanking,
    ('embedding', ): basesearch.Embedding,
    ('invindex', ): basesearch.InvertedIndex,
    ('keyinv', ): basesearch.KeyInv,
    ('base', ): basesearch.Basesearch,
}
