import utils


class BasePlugin(object):
    def __init__(self, host, port, tags):
        self.host = host
        self.port = port
        self.tags = tags

    def collect_status(self):
        raise NotImplementedError()

    def apply_config(self, config):
        raise NotImplementedError()

    def start(self):
        pass

    def stop(self):
        pass

    @property
    def itype(self):
        # TODO: use self.tags, not os.environ
        return utils.get_itype()

    @property
    def metaprj(self):
        return utils.get_metaprj()

    @classmethod
    def add_args(cls, parser):
        pass
