import logging

import requests

from . import config as config_format
from . import mongo


class ConfigsDistributorError(RuntimeError):
    pass


class ConfigNotFound(ConfigsDistributorError):
    pass


class Client(object):
    def __init__(self, url):
        self._url = url

    def load_config(self, host, port):
        url = '{}/configs/{}/{}'.format(self._url, host, port)
        headers = {
            'Accept': 'application/msgpack'
        }
        response = requests.get(url, headers=headers, timeout=10)
        if response.ok:
            return config_format.load_msgpack(response.content)
        elif response.status_code == 404:
            raise ConfigNotFound("Not found at " + url)
        else:
            raise ConfigsDistributorError("GET {} returned HTTP code {}".format(url, response.status_code))


class OverrideConfigsClient(object):
    def __init__(self):
        self._storage = mongo.override_storage()

    def override_one(self, host, port, config):
        self._storage.update({(host, port): config})
        _log.info('override %s:%s', host, port)

    def override_many(self, configs):
        self._storage.update(configs)

    def rollback_one(self, host, port):
        self._storage.remove([(host, port)])

    def rollback_many(self, hosts_ports):
        self._storage.remove(hosts_ports)

    def list(self):
        return self._storage.load()


_log = logging.getLogger(__name__)
