import pymongo

import storage


STORAGES = {}


_heartbeat_mongodb_b = [
    'myt0-4011.search.yandex.net',
    'myt0-4017.search.yandex.net',
    'sas1-6859.search.yandex.net',
    'sas1-8999.search.yandex.net',
    'vla1-3212.search.yandex.net',
]


def _make_client():
    return pymongo.MongoClient(','.join(_heartbeat_mongodb_b))


class _StorageFactory(object):
    _storage = None

    def __init__(self, name):
        self._name = name

    def get_storage(self):
        if not self._storage:
            mongo_coll = _make_client().callisto[self._name].configs
            self._storage = storage.make_storage(mongo_coll)
        return self._storage


def require(contour_name):
    return STORAGES[_path_to_name(contour_name)]


def override_storage():
    return storage.make_override_storage(_make_client().callisto.override.configs)


def _path_to_name(path):
    return path.strip('/').replace('/', '_')


def _init():
    for name in {
        'pip',
        'jupiter',
        'man_web',
        'sas_web',
        'vla_web',
        'test',
        'multi_beta',
        'imgs_multi_beta',
        'imgs_multi_meta',
        'video_multi_beta',
        'video_multi_meta',
        'multi_int',
        'multi_meta',

        'ManCallisto',
        'SasCallisto',
        'VlaCallisto',

        'NightlyTest',
        'NightlyBaseline',

        'ImgBeta',
        'ImgBeta2',
        'ImgThumbWide',
        'ImgRIMTier',

        'video',
        'pip_video',
        'man_video',
        'sas_video',
        'vla_video',

        'SaasFrozenBeta',

        _path_to_name('images/betas/multi/quick/base'),
        _path_to_name('images/betas/multi/quick'),
        _path_to_name('images/oldprod2'),
        _path_to_name('images/prod/acceptance'),
        _path_to_name('images/prod/main'),
        _path_to_name('images/prod/man'),
        _path_to_name('images/prod/sas'),
        _path_to_name('images/prod/vla'),

        _path_to_name('images/prod/rim/acceptance'),
        _path_to_name('images/prod/rim/man'),
        _path_to_name('images/prod/rim/sas'),
        _path_to_name('images/prod/rim/vla'),

        _path_to_name('images/prod/commercial'),
        _path_to_name('images/prod/commercial/acceptance'),
        _path_to_name('images/prod/commercial/man'),
        _path_to_name('images/prod/commercial/sas'),
        _path_to_name('images/prod/commercial/vla'),

        _path_to_name('saas/betas/news'),
        _path_to_name('saas/betas/news/meta'),
        _path_to_name('saas/oldprod2'),
        _path_to_name('saas/news/oldprod2'),

        _path_to_name('video/betas/multi/quick'),
        _path_to_name('video/oldprod2'),

        _path_to_name('web/oldprod2'),
        _path_to_name('web/prod/hamster'),
        _path_to_name('web/prod/man_yp'),
        _path_to_name('web/prod/new_base'),
        _path_to_name('web/prod/sas_platinum'),
        _path_to_name('web/prod/vla_yp'),
        _path_to_name('web/test/man_pre'),
        _path_to_name('web/test/multi'),
        _path_to_name('web/betas/multi/full'),

        _path_to_name('web/callisto/beta'),
        _path_to_name('web/callisto/pumpkin'),
    }:
        STORAGES[name] = _StorageFactory(name)


_init()
