import gevent.monkey
gevent.monkey.patch_all()  # noqa

import os
import logging
import logging.handlers
import argparse

import infra.callisto.libraries.logging as cajuper_logging
from infra.callisto.configs import mongo

import app as configs_app


def ensure_dir(path):
    if not os.path.exists(path):
        os.makedirs(path)


def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument('--port', help='Server port', default=8080, type=int)
    parser.add_argument('--debug', help='Debug mode (dump logs to stdout)', action='store_true', default=False)
    parser.add_argument(
        '--collections', help='collections to serve', required=True, type=str, nargs='+', choices=mongo.STORAGES
    )
    parser.add_argument(
        '--observe-override', help='observe collection with override configs', action='store_true'
    )
    return parser.parse_args()


def main():
    args = parse_args()
    cajuper_logging.configure_logging(path_to_logs='./logs', debug=args.debug)

    app = configs_app.create_app(
        [
            mongo.STORAGES[collection_name].get_storage()
            for collection_name in args.collections
        ],
        mongo.override_storage() if args.observe_override else None
    )

    from gevent.pywsgi import WSGIServer
    logging.info('listen port %s', args.port)
    WSGIServer(('::', args.port), app).serve_forever()
