#include "config.h"

#include <library/cpp/msgpack2json/msgpack2json.h>
#include <library/cpp/json/json_prettifier.h>
#include <util/stream/str.h>
#include <util/datetime/base.h>
#include <tuple>


namespace NConfigsDistributor {
    bool operator< (const TInstance& left, const TInstance& right) {
        return std::make_tuple(left.Host, left.Port) < std::make_tuple(right.Host, right.Port);
    }

    TString PrettyJson(const NJson::TJsonValue& value) {
        TStringStream stream;
        stream << value;
        TStringBuf buf = stream.Str();
        return NJson::PrettifyJson(buf);
    }

    TString TConfig::DumpHumanReadable() const {
        TStringStream stream;
        stream
                << "Host: " << Instance.Host << Endl
                << "Port: " << Instance.Port << Endl
                << "Timestamp: " << Timestamp << Endl
                << "DateTime: " << TInstant::FromValue((ui64)Timestamp * 1000 * 1000).ToString() << Endl
                << "Content: \n" << PrettyJson(Content);
        return stream.Str();
    }

    TString TConfig::DumpMsgPack() const {
        TStringStream content;
        content << Content;

        msgpack::sbuffer buffer;
        msgpack::packer<msgpack::sbuffer> pk(&buffer);

        pk.pack_map(2);
        pk.pack("timestamp");
        pk.pack_long_long(Timestamp);
        pk.pack("content");
        pk.pack(std::string(content.Str()));
        return TString(buffer.data());
    }
}
