#pragma once

#include <library/cpp/json/json_value.h>
#include <util/generic/string.h>

namespace NConfigsDistributor {
    struct TInstance {
        TString Host;
        int Port;
    };

    bool operator< (const TInstance& left, const TInstance& right);

    struct TConfig {
        TString DumpHumanReadable() const;
        TString DumpMsgPack() const;

        TInstance Instance;
        NJson::TJsonValue Content;
        long long Timestamp;
        int Version;
    };
}
