#include "handlers.h"


namespace NConfigsDistributor {
    TInstance GetHostPort(const TStringBuf &path) {
        try {
            TVector<TStringBuf> parts;
            Split(path, "/", parts);
            if (parts.size() != 3)
                ythrow yexception();
            return {TString{parts[1]}, IntFromString<int, 10>(parts[2])};
        } catch (const yexception& exc) {
            ythrow yexception() << "Cannot parse path: " << path << Endl
                                << "Expected: /configs/<host>/<int:port>";
        }
    }

    THandler::THandler(TConfigsKeeper* configsKeeper)
            : ConfigsKeeper_(configsKeeper)
    {
    }


    bool TGetConfig::MatchRequest(const NBubbleServer::TRequest &request) const {
        return request.Path.StartsWith("/configs/") && request.Method == "GET";
    }

    THttpResponse TGetConfig::Execute(const NBubbleServer::TRequest &request) {
        auto instance = GetHostPort(request.Path);
        try {
            auto config = ConfigsKeeper_->GetConfig(instance);
            if (request.Accepts("application/msgpack")) {
                return NBubbleServer::MakeResponse(HTTP_OK, config.DumpMsgPack());
            } else {
                return NBubbleServer::MakeResponse(HTTP_OK, config.DumpHumanReadable());
            }
        } catch (const std::out_of_range& exc) {
            return NBubbleServer::MakeResponse(HTTP_NOT_FOUND, "Config not found");
        }
    }
}

