#include "storage.h"
#include "observer.h"
#include "app.h"

#include <infra/bubble/daemon.h>
#include <util/string/cast.h>

int main(int argc, char** argv) {
    using namespace NConfigsDistributor;
    assert(argc >= 2);
    NMongo::Init();
    TString mongo_url = "mongodb://"
                        "myt0-4011.search.yandex.net:27017,"
                        "myt0-4017.search.yandex.net:27017,"
                        "sas1-6859.search.yandex.net:27017,"
                        "sas1-8999.search.yandex.net:27017,"
                        "vla1-3212.search.yandex.net:27017";

    TVector<TCollectionObserver> observers;
    ui16 port = FromString<ui16>(argv[1]);
    for (int i = 2; i < argc; ++i) {
        observers.push_back(TCollectionObserver(TStorage(mongo_url, "callisto", argv[i])));
    }
    auto configs_keeper = TConfigsKeeper(observers);
    SystemThreadFactory()->Run([&]() {
        while (true) {
            try {
                configs_keeper.Update();
            } catch (yexception &exc) {
                Cerr << "Could not update configs!" << Endl;
                Cerr << exc.what() << Endl;
            }
            sleep(5);
        }
    });
    auto daemon = NBubbleServer::TDaemon(port, MakeApp(&configs_keeper));
    daemon.ServeForever();
    return 0;
}
