#pragma once

#include "config.h"
#include "storage.h"
#include <library/cpp/mongo/wrappers.h>
#include <util/generic/map.h>
#include <util/system/rwlock.h>
#include <util/generic/set.h>


namespace NConfigsDistributor {
    using TConfigsMapping = TMap<TInstance, TConfig>;

    class TCollectionObserver {
    public:
        explicit TCollectionObserver(TStorage storage);
        const TConfigsMapping& GetConfigs();
        inline const TString& Name() const {
            return Storage_.Name();
        }

    private:
        long long int Timestamp_;
        TConfigsMapping Configs_;
        TStorage Storage_;
    };


    class TConfigsKeeper {
    public:
        explicit TConfigsKeeper(TVector<TCollectionObserver> observers);
        void Update();
        TConfig GetConfig(const TInstance& instance) const;

        inline TSet<TString> IntersectedConfigs() const {
            return *Intersected_;
        }

    private:
        TVector<TCollectionObserver> Observers_;
        TAtomicSharedPtr<TConfigsMapping> Configs_;
        TAtomicSharedPtr<TSet<TString>> Intersected_;
    };
}
