#include "storage.h"

namespace NConfigsDistributor {
    static struct {
        const TString Timestamp = "ts";
        const TString Host = "h";
        const TString Port = "p";
        const TString Content = "c";
    } Keys;

    class TGetter {
    public:
        explicit TGetter(const NJson::TJsonValue& value)
                : Value_(value)
        {
        }

        TString Host() const {
            return Value_[Keys.Host].GetString();
        }

        int Port() const {
            return static_cast<int>(Value_[Keys.Port].GetInteger());
        }

        long long int Timestamp() const {
            return Value_[Keys.Timestamp].GetInteger();
        }

        NJson::TJsonValue Content() const {
            return Value_[Keys.Content];
        }

    private:
        const NJson::TJsonValue& Value_;
    };


    const TString &TStorage::Name() const {
        return Name_;
    }

    TString TStorage::ConfigsCollection() const {
        return Name_ + ".configs";
    }

    TString TStorage::TimestampsCollection() const {
        return ConfigsCollection() + ".timestamps";
    }

    long long int TStorage::HeadTimestamp() {
        NJson::TJsonValue selector;
        selector[0]["$group"]["_id"] = NJson::JSON_NULL;
        selector[0]["$group"]["timestamp"]["$max"] = "$timestamp";

        NMongo::THelper helper(MongoUrl_);
        auto found = helper.Aggregate(Db_, TimestampsCollection(), selector);
        if (found.empty()) {
            return 0;
        }
        return found[0].ToJson()["timestamp"].GetInteger();
    }

    TMap<TInstance, TConfig> TStorage::Load(long long int timestamp) {
        NJson::TJsonValue selector;
        selector[Keys.Timestamp] = timestamp;
        TMap<TInstance, TConfig> result;

        NMongo::THelper helper(MongoUrl_);
        auto found = helper.Find(Db_, ConfigsCollection(), selector);
        for (const auto &value : found) {
            auto json_value = value.ToJson();
            TGetter getter(json_value);
            TInstance instance{getter.Host(), getter.Port()};
            result[instance] = {instance, getter.Content(), getter.Timestamp(), 1};
        }
        return result;
    }
}
