#pragma once

#include "config.h"
#include <library/cpp/mongo/wrappers.h>
#include <util/generic/map.h>


namespace NConfigsDistributor {
    class TStorage {
    public:
        TStorage(TString mongo_url, TString db, TString name)
                : Db_(db)
                , Name_(name)
                , MongoUrl_(mongo_url)
        {
        }

        const TString &Name() const;
        long long int HeadTimestamp();
        TMap <TInstance, TConfig> Load(long long int timestamp);

    private:
        TString ConfigsCollection() const;
        TString TimestampsCollection() const;

        TString Db_;
        TString Name_;
        TString MongoUrl_;
    };
}

