import pymongo

import storage


_STORAGES = {}


_heartbeat_mongodb_b = [
    'myt0-4011.search.yandex.net',
    'myt0-4017.search.yandex.net',
    'sas1-6859.search.yandex.net',
    'sas1-8999.search.yandex.net',
    'vla1-3212.search.yandex.net',
]


def _make_client():
    return pymongo.MongoClient(','.join(_heartbeat_mongodb_b))


class _StorageFactory(object):
    _storage = None

    def __init__(self, name):
        self._name = name

    def get_storage(self, readonly):
        if not self._storage:
            mongo_coll = _make_client().callisto[self._name].context
            self._storage = storage.make_storage(mongo_coll)
        if readonly:
            return storage.ROStorage(self._storage)
        return self._storage


def require(contour_name):
    contour_name = contour_name.strip('/').replace('/', '_')
    assert contour_name not in _STORAGES
    _STORAGES[contour_name] = _StorageFactory(contour_name)
    return _STORAGES[contour_name]
