import logging
import requests
import gevent
import gevent.lock


SANDBOX_URL = 'http://sandbox.yandex-team.ru/api/v1.0/resource/{}'


class BundleMapping(object):
    def __init__(self):
        self._cache = {}
        self._lock = gevent.lock.Semaphore(1)

    def _get_resource_rbtorrent(self, resource_id):
        resource_id = str(resource_id)
        logging.debug('resource_id: %s', resource_id)
        rbtorrent = requests.get(SANDBOX_URL.format(resource_id), timeout=10).json()['skynet_id']
        logging.debug('torrent: %s', rbtorrent)
        self._cache[resource_id] = rbtorrent.replace('rbtorrent:', '')
        return self._cache[resource_id]

    def get_resource_rbtorrent(self, resource_id):
        if resource_id not in self._cache and self._lock.acquire(blocking=False):
            try:
                gevent.with_timeout(15, self._get_resource_rbtorrent, resource_id)
            except (Exception, gevent.Timeout) as ex:
                gevent.sleep(5)
                raise ex
            finally:
                self._lock.release()
        return self._cache.get(resource_id)
