import collections

import infra.callisto.controllers.sdk as sdk
import infra.callisto.controllers.utils.bindings as bindings


class ExternalBuilderObserver(sdk.Controller):
    def __init__(self, url, tier):
        super(ExternalBuilderObserver, self).__init__()
        self._url = url
        self._builder = bindings.ROBuilder(url, tier.name)
        self._builder_state = {}

    def update(self, reports):
        self._builder_state = self._builder.state()

    def generations_status(self):
        ts = collections.defaultdict(lambda: dict(BUILD=0, DONE=0, IDLE=0, FAILURE=0, none=0))
        for shard, state in self._builder_state.items():
            ts[shard.timestamp][state.status] += 1
        return dict(ts)

    def prepared(self):
        return self._builder.prepared()

    def timestamps(self):
        return self._builder.timestamps()

    def json_view(self):
        return {
            'url': self._url,
            'full_state': self.generations_status(),
        }
