"""
    Don't use this code if you are not sure that you need it.
"""

import inspect
import functools


def memoized_recalculate_after_execute(func):
    """
        Wraps class method. Such method must accept only `self` argument.
        Method may be called only after `refresh_memoized` is executed on instance object.
        Method may be wrapped with @property as well.
    """
    return MemoizedRecalculateAfterExecute(func)


def refresh_memoized(obj):
    """
        Recalculates memoized methods/properties of object
    """
    for method in complete_class_memoized_methods_list(type(obj)):
        method.update(obj)


#


class MemoizedRecalculateAfterExecute(object):
    def __init__(self, func):
        if inspect.getargspec(func).args != ['self']:
            raise TypeError('memoized method must accept only `self` parameter')
        self.func = func

    def __get__(self, instance, owner):
        if instance is None:
            raise RuntimeError('cannot call unbound method')
        return functools.partial(self, instance)

    def __call__(self, instance):
        if self.func.__name__ not in instance.__dict__:
            raise RuntimeError('value is not set yet')
        return instance.__dict__[self.func.__name__]()

    def update(self, instance):
        result = self.func(instance)

        def fake_call_function():
            return result

        instance.__dict__[self.func.__name__] = fake_call_function


def list_memoized_methods(class_):
    methods = [
        class_.__dict__[attr] for attr in class_.__dict__
        if isinstance(class_.__dict__[attr], MemoizedRecalculateAfterExecute)
    ]
    return methods


def list_memoized_properties(class_):
    properties = [
        class_.__dict__[attr].fget for attr in class_.__dict__
        if isinstance(class_.__dict__[attr], property)
        and isinstance(class_.__dict__[attr].fget, MemoizedRecalculateAfterExecute)
    ]
    return properties


def complete_class_memoized_methods_list(class_):
    memoized_methods = []
    if hasattr(class_, '__bases__'):
        for base in class_.__bases__:
            memoized_methods += complete_class_memoized_methods_list(base)
    memoized_methods += list_memoized_methods(class_)
    memoized_methods += list_memoized_properties(class_)
    return memoized_methods
