import contextlib

import gevent.local

_context = gevent.local.local()


@contextlib.contextmanager
def set_request_context(request, root_ctrl):
    _context.request = request
    _context.root_ctrl = root_ctrl
    yield


def current_request():
    return _context.request


def current_root_ctrl():
    return _context.root_ctrl
