import os.path

import infra.callisto.libraries.memoize as memoize
import context


def get_ctrl_map(root_ctrl):
    ctrl_map = {}

    def _visit_node(root, stack):
        assert not root.path.startswith('/')
        stack.append(root.path)
        ctrl_map['/' + '/'.join(stack)] = root
        for ctrl in root.children:
            if ctrl.path:
                _visit_node(ctrl, stack)
        stack.pop()

    _visit_node(root_ctrl, [])

    return ctrl_map


@memoize.memoized
def ctrl_path(ctrl):
    for path, ctrl_ in get_ctrl_map(context.current_root_ctrl()).items():
        if ctrl is ctrl_:
            return path
    raise RuntimeError('ctrl is unreachable')


def root_path():
    request = context.current_request()
    return os.path.join('/', request.args.get('root-path', '/'))


def absolute_path(path):
    res = os.path.join(root_path(), path.lstrip('/'))
    return res
