import os
import json

from werkzeug import wrappers

import viewer
import path


class _Encoder(json.JSONEncoder):
    def default(self, obj):
        if isinstance(obj, set):
            return list(obj)
        return json.JSONEncoder.default(self, obj)


def _make_filters():
    return {
        'real_path': path.absolute_path,
        'static_path': lambda path_: os.path.join(path.root_path(), '_static_', path_.lstrip('/')),
    }


def jsonify(json_data, status_code=200):
    return wrappers.Response(
        json.dumps(json_data, indent=4, cls=_Encoder),
        content_type='application/json',
        status=status_code,
    )


def text_response(text, status_code, mime_type='text/text'):
    return wrappers.Response(text, status=status_code, mimetype=mime_type)


def render_viewer(viewer_name, data, status_code=200):
    template = viewer.get_template(viewer_name, _make_filters())
    page = template.render(**data)
    return wrappers.Response(page, status=status_code, mimetype='text/html')
