import json
import mimetypes

import jinja2
import library.python.resource as resource


class _Encoder(json.JSONEncoder):
    def default(self, obj):
        if isinstance(obj, set):
            return list(obj)
        return json.JSONEncoder.default(self, obj)


def dump_json(data):
    return json.dumps(data, indent=4, cls=_Encoder)


def _load_template_from_resources(name):
    return resource.find('/viewer/templates/{}'.format(name))


def _load_static_from_resources(name):
    return resource.find('/viewer/static/{}'.format(name))


def get_static_file(path):
    mime_type, _ = mimetypes.guess_type(path)
    return _load_static_from_resources(path), mime_type


def get_template(viewer_name, filters=()):
    return _get_jinja_env(filters).get_template('{}.html'.format(viewer_name))


def _get_jinja_env(filters=()):
    env = jinja2.Environment(
        loader=_jinja_loader,
    )
    env.filters['tojson'] = dump_json
    for name, func in filters.items():
        env.filters[name] = func
    return env


_jinja_loader = jinja2.FunctionLoader(_load_template_from_resources)
