
// reusable components


function BaseTimestamp(props) {
    let timestamp = props.timestamp;
    return (
        <div>
            <strong>{timestamp}</strong>
            <p><nobr>{timestampToYtState(timestamp)}</nobr></p>
        </div>
    )
}


function YtTimestamp(props) {
    return <p><nobr><strong>{timestampToYtState(props.timestamp)}</strong></nobr></p>;
}


function ProgressBar(props) {
    let percentage = Number(props.percentage).toFixed(2) + '%';
    let className = props.percentage === 100 ? 'progress-bar' : 'progress-bar progress-bar-striped';
    if (props.style) {
        className += ' progress-bar-' + props.style;
    }
    return (
        <div className="progress">
            <div className={className} style={{width: percentage}}>
                {percentage}
            </div>
        </div>
    );
}


function Banner(props) {
    let className = 'alert alert-' + props.style;
    return (
        <div className={className}><h4>
            {props.text}
        </h4></div>
    );
}


function Href(props) {
    return <a href={props.url}>{props.text}</a>
}


// blocks


let blocks = {
    'Block': Block,
    'Header': Header,
    'Href': Href,
    'Progress': Progress,
    'Shard': Shard,
    'BuilderView': BuilderView,
    'SearchView': SearchView,
    'DoubleProgress': Block,
    'DeployView': DeployView,
    'SlotView': SlotView,
    'Intl2Target': Intl2Target,
    'Intl2View': Intl2View,
    'HrefList': HrefList,
    'Banner': Banner,
    'TableTierView': TableTierView,
    'TableView': TableView,
    'InnerTableRow': InnerTableRow,
    'YtTimestamp': YtTimestamp,
};


function makeBlock(jsonData) {
    let Tag = blocks[jsonData['type'] || 'Block'];
    return React.createElement(Tag, jsonData);
}


function Block(props) {
    let subs = props.subs.map(makeBlock);
    return <div>{subs}</div>;
}


function Header(props) {
    let tag = `h${props.level}`;
    return React.createElement(tag, null, [props.text]);
}


function HrefList(props) {
    let subs = props.subs.map((sub) =>
        <li key={'' + sub.url + sub.text}>
            <Href url={sub.url} text={sub.text} />
        </li>
    );
    return <ul className="list-inline">{subs}</ul>;
}


function Progress(props) {
    let percentage = 100 * props.done / props.total;
    let description = `${props.done} of ${props.total}`;
    return (
        <div>
            <div style={{textAlign: 'center'}}>
                {description}
            </div>
            <ProgressBar percentage={percentage} style={props.style} />
        </div>
    );
}


function Name({name, className, children}) {
    return (
        <div className={className} key={name + className}>
            <h4>{name}</h4>
            <h5>{className}</h5>
            {children}
        </div>
    );
}


function State(props) {
    let children = React.Children.map(props.children, (inner =>
        <div className="col-md-2">
            {inner}
        </div>
    ));
    return (
        <div className="row" key={props.timestamp}>
            <div className="col-md-2">
                <BaseTimestamp timestamp={props.timestamp} />
            </div>
            <div className="col-md-1"/>
            {children}
        </div>
    );
}


function BuilderBar(host, port, shard, style) {
    let hostPort = `${host}:${port}`;
    let path = realPath(`logs?builder=${hostPort}&shard=${shard}`);
    return (
        <span key={hostPort} className={'deployer label label-' + style}>
            <a style={ {color: 'inherit'} } href={path}>{hostPort}</a>
        </span>
    );
}


function Shard(props) {
    return (
        <div className="shard">
            <div>{props.shard.name}</div>
        </div>
    );
}


function _progress_view(props, className) {
    let states = props.subs.map((sub) =>
        <State timestamp={sub.timestamp}>
            {makeBlock(sub)}
        </State>
    );
    return (
        <Name name={props.name} className={className}>
            {HrefList(props.href_list)}
            {states}
        </Name>
    );
}


function BuilderView(props) {
    return _progress_view(props, BuilderView.name);
}


function SearchView(props) {
    return _progress_view(props, SearchView.name);
}


function DeployView(props) {
    return _progress_view(props, DeployView.name);
}


function _searchDeplByTimestamp(deploy, search) {
    let result = {};
    for (let ts of search.subs.concat(deploy.subs).map((sub => sub.timestamp)))
        result[ts] = {deploy: null, search: null};
    for (let sub of deploy.subs)
        result[sub.timestamp].deploy = sub;
    for (let sub of search.subs)
        result[sub.timestamp].search = sub;

    return result;
}


function SlotView(props) {
    let searchDeplByTimestamp = _searchDeplByTimestamp(props.deploy, props.search);
    let timestamps = Object.keys(searchDeplByTimestamp).sort().reverse();
    let subs = timestamps.map(function(timestamp) {
        let deploy = searchDeplByTimestamp[timestamp].deploy;
        let search = searchDeplByTimestamp[timestamp].search;
        return (
            <State timestamp={timestamp}>
                <Name name='' className={DeployView.name}>
                    <Block subs={deploy && deploy.subs || []} />
                </Name>
                <Name name='' className={SearchView.name}>
                    <Block subs={search && search.subs || []} />
                </Name>
            </State>
        )
    });
    return (
        <Name name={props.name} className={SlotView.name}>
            {HrefList(props.deploy.href_list)}
            {subs}
        </Name>
    );
}


function Intl2View(props) {
    let target = makeBlock(props.target);
    let progress = makeBlock(props.progress);
    let inner = (
        <div>
            <div className="Intl2Target" key="target">
                <h5>Target</h5>
                {target}
            </div>
            <div className="row Intl2Progress" key="progress">
                <div className="col-md-3">
                    <h5>Progress</h5>
                </div>
                <div className="col-md-2">
                    {progress}
                </div>
            </div>
        </div>
    );
    return <Name name='Intl2'>{inner}</Name>;
}


function Intl2Target(props) {
    let slotsTargets = props.slots_targets;
    let totalLength = 0;
    let timestamps = {};

    for (let slot of Object.keys(slotsTargets)) {
        if (slotsTargets[slot] !== null) {
            let ts = slotsTargets[slot].timestamp;
            timestamps[ts] = (timestamps[ts] || 0) + 1;
            totalLength += 1;
        }
    }

    let bars = Object.keys(timestamps).sort().reverse().map((ts) =>
        <State timestamp={ts} key={ts}>
             <Progress done={timestamps[ts]} total={totalLength} />
        </State>
    );

    return <div>{bars}</div>;
}


function makeHeader(block) {
    return <p align="center" style={{fontSize:'x-large'}}>{makeBlock(block)}</p>;
}


function makeTableRow(cols, col_width, is_header) {
    let blocks = cols.map(function(col, index) {
        let className = "col-md-" + col_width[index] + " col-xs-" + col_width[index];
        return <div className={className}>{is_header ? makeHeader(col) : makeBlock(col)}</div>;
    });
    return (<div>
        <div className="row">{blocks}</div>
        <div className="row" style={{height:'40px' }}> </div>
    </div>);
}


function TableTierView(props) {
    let blocks = props.subs.map((block) =>
        makeBlock(block)
    );
    return <div>{props.name} {HrefList(props.href_list)} {blocks}</div>;
}


function InnerTableRow(props) {
    let blocks = props.cols.map(function(col, index) {
        let className = "col-md-" + props.col_width[index] + " col-xs-" + props.col_width[index];
        return <div className={className}>{makeBlock(col)}</div>
    });
    return <div className="row">{blocks}</div>;
}


function TableView(props) {
    let blocks = props.blocks.map(function(block, index) { return makeTableRow(block, props.col_width, props.header_num === index);});
    return <div className="container-fluid">{blocks}</div>;
}
