

function leftJustify(str, length=2, char='0') {
    str = '' + str;
    let fill = [];
    while ( fill.length + str.length < length ) {
      fill[fill.length] = char;
    }
    return fill.join('') + str;
}


function timestampToYtState(timestamp) {
    if (!timestamp)
        return null;
    let date = new Date(parseInt(timestamp) * 1000);
    let ytDate = '' + date.getFullYear() + leftJustify(date.getMonth() + 1) + leftJustify(date.getDate());
    let ytTime = '' + leftJustify(date.getHours()) + leftJustify(date.getMinutes()) + leftJustify(date.getSeconds());
    return ytDate + '-' + ytTime;
}


function moduleToArcanumHref(module, svn_revision=null) {
    let arcHref = 'https://a.yandex-team.ru/arc/trunk/arcadia/';
    arcHref = arcHref + module.replace(/\./g, '/') + '.py';
    if (svn_revision) {
        return arcHref + '?rev=' + svn_revision;
    } else {
        return arcHref;
    }
}


function getParameterByName(name, url) {
    if (!url) url = document.URL;
    name = name.replace(/[\[\]]/g, "\\$&");
    let regex = new RegExp("[?&]" + name + "(=([^&#]*)|&|#|$)"),
        results = regex.exec(url);
    if (!results) return null;
    if (!results[2]) return '';
    return decodeURIComponent(results[2].replace(/\+/g, " "));
}


function GetJSON(url) {
    let httpReq = new XMLHttpRequest();
    httpReq.open("GET", url, false);
    httpReq.send(null);
    return JSON.parse(httpReq.responseText);
}


function pathJoin(parts, sep){
   let separator = sep || '/';
   let replace   = new RegExp(separator+'{1,}', 'g');
   return parts.join(separator).replace(replace, separator);
}


function updateQueryStringParameter(uri, key, value) {
    let re = new RegExp("([?&])" + key + "=.*?(&|$)", "i");
    let separator = uri.indexOf('?') !== -1 ? "&" : "?";
    if (uri.match(re)) {
        return uri.replace(re, '$1' + key + "=" + value + '$2');
    }
    else {
        return uri + separator + key + "=" + value;
    }
}
