"""
    Links between controllers
"""

import logging

import infra.callisto.controllers.utils.funcs as funcs

_links = dict()
_log = logging.getLogger(__name__)


def register(ctrl):
    if ctrl not in _links:
        _links[ctrl] = []


def add_link(parent_ctrl, child_ctrl):
    if child_ctrl not in _links[parent_ctrl]:
        _links[parent_ctrl].append(child_ctrl)
        _log.info('add %s -> %s', parent_ctrl, child_ctrl)


def children(ctrl):
    return _links[ctrl][:]


def topological_sort(root_ctrl, reverse=False):
    return funcs.topological_sort(root_ctrl, _links, reverse)


def all_ctrls():
    return _links.keys()
