import infra.callisto.controllers.sdk as sdk


class GeneratorProdTable(sdk.Controller):
    path = 'generator'

    def __init__(self, prod_table, yappy_table, configs_table, output_table, serving_slots_ids):
        super(GeneratorProdTable, self).__init__()
        self._prod_table = prod_table
        self._yappy = yappy_table
        self._configs = configs_table
        self._output_table = output_table
        self._serving_slots_ids = serving_slots_ids

    def execute(self):
        prod_config = self._prod_common_config()

        for slot_id in set(self._yappy.slot_ids()) & set(self._configs.slot_ids()) & set(self._serving_slots_ids):
            yappy_conf = self._yappy.slot_configuration(slot_id)
            slot_configs = self._configs.slot_configs(slot_id)
            target = self._eval_target(yappy_conf, prod_config, slot_configs)
            self._output_table.push(slot_id, target)

    def _prod_common_config(self):
        raise NotImplementedError()

    def html_view(self):
        hrefs = sdk.blocks.HrefList([
            sdk.blocks.Href('prod-table', self._prod_table.gui_url),
            sdk.blocks.Href('yappy-table', self._yappy.gui_url),
            sdk.blocks.Href('configs-table', self._configs.gui_url),
            sdk.blocks.Href('output-table', self._output_table.gui_url),
        ])
        return sdk.blocks.wrap(sdk.blocks.Header('Generator'), hrefs)

    def _eval_target(self, yappy_conf, prod_conf, configs):
        raise NotImplementedError()


def get_resource(resource_name, yappy_conf, prod_conf):
    if yappy_conf[resource_name] != 'default':
        return yappy_conf[resource_name]
    if prod_conf:
        return 'sbr:{}'.format(prod_conf[resource_name]['resource_id'])
    raise RuntimeError('cannot resolve default resource %s', resource_name)


def _convert_prod_common_config_to_yappy(cfg):
    return {
        'basesearch.executable': cfg.base['httpsearch'],
        'basesearch.models': cfg.base['models.archive'],
        'mmeta.executable': cfg.mmeta['httpsearch'],
        'mmeta.models': cfg.mmeta['models.archive'],
        'intsearch.executable': cfg.int['httpsearch'],
    }
