import infra.callisto.controllers.utils.secrets as secrets
import infra.nanny.nanny_services_rest.nanny_services_rest.client as nanny

import entities


def get_service_resources(service_name, resource_types):
    resources = dict.fromkeys(resource_types.values())

    for resource in _get_service_sandbox_files(service_name):
        matched_type = _matched_resource_type(resource, resource_types)
        if matched_type:
            resources[resource_types[matched_type]] = _filter_resource_desc(resource)

    return resources


def get_service_shardmap(service_name):
    bsconfig_shard = _get_service_shardmap(service_name)

    return bsconfig_shard.get('sandbox_shardmap')


def _matched_resource_type(resource, resource_types):
    search_resource_type = entities.ResourceType(
        resource_type=resource['resource_type'],
        task_type=resource['task_type'],
    )

    if search_resource_type in resource_types:
        return search_resource_type

    search_resource_type = entities.ResourceType(
        resource_type=resource['resource_type'],
        task_type=None,
    )

    if search_resource_type in resource_types:
        return search_resource_type

    return None


def _filter_resource_desc(nanny_sandbox_resource):
    return {
        k: v
        for k, v in nanny_sandbox_resource.iteritems()
        if k in {'resource_id', 'task_id'}
    }


def _get_service_sandbox_files(service):
    return _get_service_resources(service)['sandbox_files']


def _get_service_shardmap(service):
    return _get_service_resources(service)['sandbox_bsc_shard']


def _get_service_resources(service):
    NANNY_URL = 'https://nanny.yandex-team.ru'

    nanny_client = nanny.ServiceRepoClient(
        NANNY_URL,
        secrets.find_nanny_token(),
        attempts=5,
        timeout=1,
        delay=1,
    )

    return nanny_client.get_active_runtime_attrs(service)['content']['resources']
