import collections
import json

import infra.callisto.controllers.sdk.table.status as table_status


class ProductionStatus(table_status.Status):
    schema = [
        {'name': 'db_timestamp', 'type': 'int64'},
        {'name': 'config', 'type': 'string'},
    ]

    def __init__(self, db_timestamp, config):
        self.db_timestamp = db_timestamp
        self.config = config

    def __cmp__(self, other):
        if not other:
            return 1
        return 0 if (self.db_timestamp, self.config) == (other.db_timestamp, other.config) else -1

    def dump_row(self):
        return {
            'db_timestamp': self.db_timestamp,
            'config': json.dumps(self.config if self.config else {}, sort_keys=True)
        }

    @classmethod
    def load_row(cls, row):
        return cls(
            db_timestamp=row['db_timestamp'],
            config=json.loads(row['config']),
        )


class ProductionStatusTable(table_status.StatusTable):
    status_class = ProductionStatus

    def last_status(self):
        head = self.head()
        return head.status if head else self.status_class(None, None)

    @property
    def common_config(self):
        last_status = self.last_status()

        CommonConfig = collections.namedtuple('CommonConfig', last_status.config.keys())

        return CommonConfig(*last_status.config.values())

    @property
    def common_state(self):
        last_status = self.last_status()

        return last_status.db_timestamp
