import logging


class SearchRuler(object):
    def __init__(self, acceptance_source, target_tables, status_tables):
        self._acceptance_source = acceptance_source
        self._target_tables = target_tables
        self._status_tables = status_tables

    def next_timestamp(self, current_timestamp):
        skipped_timestamps = self._acceptance_source.load().skipped
        locations_deploy_target_timestamps = [
            frozenset(table.head().target.deploy)
            for table in self._target_tables
        ]
        deploy_timestamps = find_common(locations_deploy_target_timestamps)
        if not deploy_timestamps:
            _log.info('no common deploy targets, cannot eval next_timestamp')
            return None
        return next_timestamp(deploy_timestamps, skipped_timestamps, current_timestamp)

    def is_deployed(self, timestamp):
        locations_deploy_observed_timestamps = [
            frozenset(table.head().status.deploy)
            for table in self._status_tables
        ]
        common_deploy_observed_timestamps = frozenset.intersection(*locations_deploy_observed_timestamps)
        return timestamp in common_deploy_observed_timestamps

    def is_accepted(self, timestamp):
        accepted_timestamps = self._acceptance_source.load().accepted
        return timestamp in accepted_timestamps


def find_common(items):
    unique_items = set(items)
    return unique_items.pop() if len(unique_items) == 1 else None


def next_timestamp(deploy_timestamps, skipped_timestamps, current_timestamp):
    not_skipped_timestamps = {
        timestamp for timestamp in deploy_timestamps
        if timestamp not in skipped_timestamps
        and timestamp > current_timestamp
    }
    return min(not_skipped_timestamps) if not_skipped_timestamps else None


_log = logging.getLogger(__name__)
