"""
    All functions work only while handling request (user json/html views and handlers)
"""

import functools

import infra.callisto.controllers.core.http.context as _context
import infra.callisto.controllers.core.http.path as _path
import infra.callisto.controllers.core.http.response as _response


def add_attributes_to_callable(func, **attributes):
    @functools.wraps(func)
    def wrapper(*args, **kwargs):
        return func(*args, **kwargs)
    for name, value in attributes.items():
        setattr(wrapper, name, value)
    return wrapper


def add_viewer(viewer_name='auto'):
    def wrap(func):
        return add_attributes_to_callable(func, viewer_name=viewer_name)
    return wrap


def proto_request(request_message_type=None):
    def wrap(func):
        return add_attributes_to_callable(func, proto=True, request_message_type=request_message_type)
    return wrap


def current_request():
    return _context.current_request()


def ctrl_path(ctrl):
    """relative path of ctrl in tree"""
    return _path.ctrl_path(ctrl)


def absolute_path(path):
    """makes path absolute"""
    return _path.absolute_path(path)


def jsonify(json_data, status_code=200):
    return _response.jsonify(json_data, status_code)
