import infra.callisto.libraries.memoize as memoize
import infra.callisto.controllers.utils.entities as entities
import infra.callisto.deploy.resource as deploy_resource

import tier as tiers

_cached = memoize.get_cache(records_limit=12 * 1000 * 1000)


Resource = deploy_resource.Resource


@_cached
def shard_to_resource(namespace_prefix, shard):
    return Resource(
        namespace=_shard_namespace(namespace_prefix, shard),
        name=shard.fullname,
    )


@_cached
def resource_to_shard(namespace_prefix, resource):
    assert resource.namespace.startswith(namespace_prefix), \
        'Namespace {} does not starts with {}'.format(
            resource.namespace, namespace_prefix
        )

    return tiers.parse_shard(resource.name)


@_cached
def chunk_to_resource(namespace_prefix, chunk, subresource=''):
    return Resource(
        namespace=_shard_namespace(namespace_prefix, chunk.shard),
        name=deploy_resource.safe_join_path(chunk.shard.fullname, chunk.path, subresource),
    )


@_cached
def resource_to_chunk(namespace_prefix, resource,):
    assert resource.namespace.startswith(namespace_prefix), \
        'Namespace {} does not starts with {}'.format(
            resource.namespace, namespace_prefix
        )

    assert '/' in resource.name
    shard_name, _, path = resource.name.partition('/')
    return entities.Chunk(tiers.parse_shard(shard_name), '/'.join(path.split('/')[:3]))


def _shard_namespace(namespace_prefix, shard):
    return deploy_resource.safe_join_path(
        '/',
        namespace_prefix,
        str(shard.timestamp),
        shard.tier.name,
    )
