import logging


class Readonly(object):
    def __init__(self, table):
        self._table = table

    def __getattr__(self, item):
        return getattr(self._table, item)

    def head(self):
        return self._table.head()

    def write(self, *args, **kwargs):
        _log.debug('readonly write to %s: [%s], {%s}', self._table, args, kwargs)

    def __str__(self):
        return 'Readonly({})'.format(self._table)

    def __repr__(self):
        return str(self)


_log = logging.getLogger('sdk.table.readonly')
