

class Record(object):
    schema = None

    def dump_row(self):
        raise NotImplementedError()

    @classmethod
    def load_row(cls, row):
        raise NotImplementedError()

    def __repr__(self):
        row = self.dump_row()
        as_str = ', '.join('{}={!r}'.format(column['name'], row[column['name']]) for column in self.schema)
        return '{}({})'.format(self.__class__.__name__, as_str)

    def __eq__(self, other):
        return type(self) == type(other) and self.dump_row() == other.dump_row()

    def __ne__(self, other):
        return not (self == other)
