def list_keys(keys):
    def underscore(s):
        return s.replace('-', '_')

    def minus(s):
        return s.replace('_', '-')

    def upper(s):
        return s.upper()

    def lower(s):
        return s.lower()

    def id_(s):
        return s

    for key in keys:
        for f1 in (id_, lower, upper):
            for f2 in (id_, minus, underscore):
                yield f2(f1(key))


def match_banned_group(provider, banned_sets):
    for key in list_keys(provider.group_keys()):
        if key in banned_sets:
            return True
    return False
