import collections

from infra.callisto.controllers.slots import slot as slot_


class SoftContour(object):
    def __init__(self, name, tier, slots, deployer_group, intl2_group, builder_provider, builder_url, hamster):
        self._name = name
        self._tier = tier
        self._slots = slots
        self._deployer_group = deployer_group
        self._intl2_group = intl2_group
        self._builder_provider = builder_provider
        self._builder_url = builder_url
        self._hamster = hamster

    @property
    def name(self):
        return self._name

    @property
    def slots(self):
        return self._slots

    @property
    def deployer_group(self):
        return self._deployer_group

    @property
    def intl2_group(self):
        return self._intl2_group

    @property
    def builder_provider(self):
        return self._builder_provider

    @property
    def builder_url(self):
        return self._builder_url

    @property
    def hamster(self):
        return self._hamster

    @property
    def tier(self):
        return self._tier


Hamster = collections.namedtuple('Hamster', 'intl2_group')


def make_contour(
    name,
    tier,
    basesearch_group,
    deployer_group,
    intl2_group,
    builder_provider=None,
    builder_url=None,
    hamster_intl2_group=None,
):
    return SoftContour(
        name,
        tier,
        {
            shard_group_number: slot_.CallistoSlot(
                '{}-{}'.format(name, shard_group_number),
                tier,
                basesearch_group.name,
                basesearch_group.tag,
                use_mtn=basesearch_group.mtn,
            )
            for shard_group_number in range(tier.groups_count + 1)
        },
        deployer_group,
        intl2_group,
        builder_provider=builder_provider,
        builder_url=builder_url,
        hamster=Hamster(hamster_intl2_group) if hamster_intl2_group else None
    )
