import collections

from ...utils import entities
from ...slots import state as slots_state


_IntL2 = collections.namedtuple('_IntL2', [
    'host',
    'port',
    'state',
    'reported_at',
])


class IntL2(_IntL2):
    def __new__(cls, host, port, state, reported_at):
        return super(cls, cls).__new__(
            cls,
            str(host),
            int(port),
            state,
            reported_at
        )

    @property
    def instance(self):
        return self.agent.instance

    @property
    def agent(self):
        return entities.Agent(self.host, self.port)

    def __str__(self):
        return 'IntL2(%s)' % self.instance

    def json(self):
        return dict(
            host=self.host,
            port=self.port,
            state=self.state,
            reported_at=self.reported_at
        )


def _get_state(contour, data):
    res = slots_state.empty_mapping(contour)
    for slot, state_ in data.items():
        if state_:
            res[int(slot)] = slots_state.SlotState(
                timestamp=state_['timestamp'],
                group_number=state_['group_number'],
            )
    return res


def convert_report_to_intl2_report(contour, report):
    return IntL2(
        report.host,
        report.port,
        _get_state(contour, report.data),
        report.generation_time,
    )
