import infra.callisto.controllers.sdk.tier as tiers
import infra.callisto.controllers.sdk.registry as registry
import infra.callisto.controllers.soft_contour as soft_contour
import infra.callisto.controllers.utils.gencfg_api as gencfg_api
import infra.callisto.controllers.build as build
import infra.callisto.controllers.build.yt_observer as yt_observer
import infra.callisto.controllers.build.source as sources

import deploy_params
import yt_observers


def make_beta_callisto(readonly):
    tag = 'stable-151-r715'
    builders_tag = 'stable-151-r715'
    deploy_group = gencfg_api.GencfgGroup('VLA_CALLISTO_MERCURY_DEPLOY', tag, mtn=True)
    contour = soft_contour.make_contour(
        'BetaCallisto',
        tiers.WebFreshTier,
        gencfg_api.GencfgGroup('VLA_WEB_CALLISTO_MERCURY_BASE', tag, mtn=True),
        deploy_group,
        gencfg_api.GencfgGroup('VLA_WEB_CALLISTO_MERCURY_INTL2', tag, mtn=True),
        builder_provider=gencfg_api.InstanceProvider(
            [gencfg_api.GencfgGroup('VLA_CALLISTO_MERCURY_BUILD', builders_tag, mtn=True)],
            report_tags={'VLA_CALLISTO_MERCURY_BUILD'}
        ),
    )
    return soft_contour.make_controller2(
        contour,
        yt_observers.BetaYtObserver,
        namespace_prefix='/web/betas/callisto/',
        deploy_params=deploy_params.DownloadArgs(gencfg_api.get_agents_instances([deploy_group]))
    )


def make_pumpkin(readonly):
    # to README.md:
    # https://nanny.yandex-team.ru/ui/#/services/catalog/sas_callisto_pumpkin_build/
    return build.innerbuilder.make_controller(
        yt_observer.Observer(name='WebFreshTierPumpkin', tier=tiers.WebFreshTier,
                             source=sources.YtTableSource('//home/callisto/shard_deploy/callisto_base',
                                                          'hahn.yt.yandex.net'),
                             build_task_type=yt_observers.BuildCallistoPumpkinShard,
                             namespace='/web/callisto',
                             tracker_url='http://sas-tracker.clusterstate.yandex-team.ru'),
        instance_provider=gencfg_api.InstanceProvider(
            [gencfg_api.GencfgGroup('SAS_CALLISTO_PUMPKIN_BUILD', 'stable-152-r473', mtn=True)],
            report_tags={'SAS_CALLISTO_PUMPKIN_BUILD'}
        ),
        assist_last_n_on_finish=5, space_needed_full_build_coeff=1, space_needed_inc_build_coeff=1)


registry.register('web/callisto/beta', make_beta_callisto, [registry.ReportsBackends.V2.vla], sleep_time=5)
registry.register('web/callisto/pumpkin', make_pumpkin, [registry.ReportsBackends.V2.sas])
