class DownloadArgs(object):
    def __init__(self, deployer_instances):
        self._hdd_only_hosts = {
            agent.host for agent, spec in deployer_instances.items()
            if 'itag_copy_on_ssd' not in spec['tags']
        }
        self._slow_network_hosts = {
            agent.host for agent, spec in deployer_instances.items()
            if spec['host_resources'].get('net', 0) < 1100  # less then 1Gbit
        }

    def __call__(self, resource, host):
        if host in self._hdd_only_hosts:
            max_dl_speed = '16M'
        elif host in self._slow_network_hosts:
            max_dl_speed = '30M'
        else:
            max_dl_speed = '40M'

        skybone_params = {
            'max_dl_speed': max_dl_speed,
            'hardlink': True,
            'copier_opts': '{direct_write: 0, subproc: 0}',
            'check_policy': False,
            'container_params': {},
        }

        return skybone_params


class DownloadArgsNewKernel(DownloadArgs):
    def __call__(self, resource, host):
        if host in self._hdd_only_hosts:
            io_limit = '15M'
        elif host in self._slow_network_hosts:
            io_limit = '25M'
        else:
            io_limit = '35M'

        skybone_params = super(DownloadArgsNewKernel, self).__call__(resource, host)
        skybone_params['container_params'] = {
            'io_limit': '/ssd: {}'.format(io_limit),
            'io_policy': 'idle',
            'io_weight': 0.01
        }
        skybone_params['copier_opts'] = '{direct_write: 1, subproc: 1, max_write_chunk: 131072}'

        return skybone_params
