import infra.callisto.controllers.sdk.registry as registry
import infra.callisto.controllers.sdk.tier as tiers
import infra.callisto.controllers.soft_contour as soft_contour
import infra.callisto.controllers.utils.gencfg_api as gencfg_api

import deploy_params
import yt_observers


def make_man_callisto(readonly):
    tag = 'stable-155-r60'
    deploy_group = gencfg_api.GencfgGroup('MAN_CALLISTO_DEPLOY', tag, mtn=True)
    contour = soft_contour.make_contour(
        'ManCallisto',
        tiers.WebFreshTier,
        gencfg_api.GencfgGroup('MAN_WEB_CALLISTO_CAM_BASE', tag, mtn=True),
        deploy_group,
        gencfg_api.GencfgGroup('MAN_WEB_CALLISTO_CAM_INTL2', tag, mtn=True),
        builder_url='http://ctrl.clusterstate.yandex-team.ru/callisto/vla/',
    )
    return soft_contour.make_controller2(
        contour,
        yt_observers.YtObserver,
        namespace_prefix='/web/callisto/',
        deploy_params=deploy_params.DownloadArgsNewKernel(gencfg_api.get_agents_instances([deploy_group]))
    )


registry.register('web/callisto/prod/man', make_man_callisto, [registry.ReportsBackends.V2.man], sleep_time=5)
