import infra.callisto.controllers.sdk.registry as registry
import infra.callisto.controllers.sdk.tier as tiers
import infra.callisto.controllers.soft_contour as soft_contour
import infra.callisto.controllers.utils.gencfg_api as gencfg_api

import deploy_params
import yt_observers


def make_sas_callisto(readonly):
    tag = 'stable-158-r2079'
    deploy_group = gencfg_api.GencfgGroup('SAS_CALLISTO_DEPLOY', tag, mtn=True)
    contour = soft_contour.make_contour(
        'SasCallisto',
        tiers.WebFreshTier,
        gencfg_api.GencfgGroup('SAS_WEB_CALLISTO_CAM_BASE', tag, mtn=True),
        deploy_group,
        gencfg_api.GencfgGroup('SAS_WEB_CALLISTO_CAM_INTL2', tag, mtn=True),
        builder_url='http://ctrl.clusterstate.yandex-team.ru/callisto/vla/',
        hamster_intl2_group=gencfg_api.GencfgGroup('SAS_WEB_CALLISTO_CAM_INTL2_HAMSTER', tag, mtn=True),
    )
    return soft_contour.make_controller2(
        contour,
        yt_observers.YtObserver,
        namespace_prefix='/web/callisto/',
        deploy_params=deploy_params.DownloadArgsNewKernel(gencfg_api.get_agents_instances([deploy_group]))
    )


registry.register('web/callisto/prod/sas', make_sas_callisto, [registry.ReportsBackends.V2.sas], sleep_time=5)
