import infra.callisto.controllers.sdk.tier as tiers
import infra.callisto.controllers.sdk.registry as registry
import infra.callisto.controllers.soft_contour as soft_contour
import infra.callisto.controllers.utils.gencfg_api as gencfg_api

import yt_observers


def make_vla_callisto(readonly):
    tag = 'stable-158-r2089'
    builders_tag = 'stable-150-r853'
    contour = soft_contour.make_contour(
        'VlaCallisto',
        tiers.WebFreshTier,
        gencfg_api.GencfgGroup('VLA_WEB_CALLISTO_CAM_BASE', tag, mtn=False),
        gencfg_api.GencfgGroup('VLA_CALLISTO_DEPLOY', tag, mtn=True),
        gencfg_api.GencfgGroup('VLA_WEB_CALLISTO_CAM_INTL2', tag, mtn=True),
        builder_provider=gencfg_api.InstanceProvider(
            [gencfg_api.GencfgGroup('VLA_CALLISTO_BUILD', builders_tag, mtn=True)],
            report_tags={'VLA_CALLISTO_BUILD'}
        ),
        hamster_intl2_group=gencfg_api.GencfgGroup('VLA_WEB_CALLISTO_CAM_INTL2_HAMSTER', tag, mtn=True),
    )
    return soft_contour.make_controller(contour, yt_observers.YtObserver)


registry.register('web/callisto/prod/vla', make_vla_callisto, [registry.ReportsBackends.V2.vla], sleep_time=5)
