import infra.callisto.controllers.build.yt_observer as yt_observer
import infra.callisto.controllers.build.source as sources
import infra.callisto.controllers.build.task as tasks
import infra.callisto.controllers.sdk.tier as tiers


class BuildCallistoIncrementalShard(tasks.BuildShardIncremental):
    gencfg_tier = tiers.WebFreshTier
    yt_proxy = 'arnold.yt.yandex.net'
    yt_root = '//home/callisto'
    callisto_mode = 'true'
    entry_point = 'JUPITER_BUNDLE/run.sh'
    bundle_type = 'callisto'

    def produce_config(self):
        cfg = super(BuildCallistoIncrementalShard, self).produce_config()
        self_shard = self.gencfg_tier.make_shard(self.number, self.timestamp)
        number = self.gencfg_tier.shards_in_group * self_shard.group_number + self_shard.shard_number
        cfg['args']['number'] = '0-{}'.format(number)
        cfg['args']['env']['BUCKETS_COUNT'] = 1
        return cfg


class BuildCallistoBetaShard(BuildCallistoIncrementalShard):
    pass


class BuildCallistoPumpkinShard(BuildCallistoIncrementalShard):
    yt_proxy = 'hahn.yt.yandex.net'


YtObserver = yt_observer.Observer(
    tier=tiers.WebFreshTier,
    name='WebFreshTier',
    source=sources.YtTableSource(
        '//home/callisto/shard_deploy/callisto_base',
        proxy='arnold.yt.yandex.net'
    ),
    build_task_type=BuildCallistoIncrementalShard,
    namespace='/web/callisto/',
    tracker_url='http://vla-tracker-cajuper.n.yandex-team.ru',
)

BetaYtObserver = yt_observer.Observer(
    tier=tiers.WebFreshTier,
    name='WebFreshTierBeta',
    source=sources.YtTableSource(
        '//home/jupiter-test/callisto_nightly/shard_deploy/callisto_base',
        proxy='arnold.yt.yandex.net'
    ),
    build_task_type=BuildCallistoBetaShard,
    namespace='/web/betas/callisto/',
    tracker_url='http://vla-tracker-cajuper.n.yandex-team.ru',
)
