import infra.callisto.controllers.multi_contour2 as multi_contour2
import infra.callisto.controllers.slots as slots
import infra.callisto.controllers.sdk.registry as registry
import infra.callisto.controllers.sdk.tier as tiers
import infra.callisto.controllers.utils.gencfg_api as gencfg_api
import infra.callisto.controllers.utils.yp_utils as yp_utils
import yt_observers

Tag = 'stable-153-r215'


def make_controller(readonly):
    contour = multi_contour2.Contour(
        deployer_spec=multi_contour2.DeployerSpec([('VLA_IMGS_BETA2_DEPLOY', Tag)], use_mtn=True),
        builders_specs=[
            multi_contour2.BuildCtrlSpec(
                yt_observer=yt_observers.ImgTier0Beta2,
                instance_provider=yp_utils.InstanceProvider(
                    [yp_utils.DeploySlot('vla', 'vla-images-search.tier0-builder-beta2', 5000)],
                    {'vla-images-search.tier0-builder-beta2'},
                    cache_for=1800
                ),
                assist_last_n_on_finish=5,
                space_needed_full_build_coeff=1
            ),
            multi_contour2.BuildCtrlSpec(
                yt_observer=yt_observers.ImgEmbeddingTier0Beta2,
                instance_provider=gencfg_api.InstanceProvider(
                    [gencfg_api.GencfgGroup('VLA_IMGS_EMBEDDING_BETA_BUILD', Tag, mtn=True)],
                    report_tags={'VLA_IMGS_EMBEDDING_BETA_BUILD'}
                ),
                assist_last_n_on_finish=5,
                space_needed_full_build_coeff=1),
            multi_contour2.BuildCtrlSpec(
                yt_observer=yt_observers.ImgInvIndexTier0Beta2,
                instance_provider=gencfg_api.InstanceProvider(
                    [gencfg_api.GencfgGroup('VLA_IMGS_INVERTED_INDEX_BETA_BUILD', Tag, mtn=True)],
                    report_tags={'VLA_IMGS_INVERTED_INDEX_BETA_BUILD'}
                ),
                assist_last_n_on_finish=5,
                space_needed_full_build_coeff=1
            ),
            multi_contour2.BuildCtrlSpec(
                yt_observer=yt_observers.ImgMmetaTier0Beta2,
                instance_provider=gencfg_api.InstanceProvider(
                    [gencfg_api.GencfgGroup('VLA_IMGS_MMETA_NIGHTLY2_BUILD', Tag, mtn=True)],
                    report_tags={'VLA_IMGS_MMETA_NIGHTLY2_BUILD'}
                ),
                assist_last_n_on_finish=1,
                space_needed_full_build_coeff=1
            ),
        ],
        sources_specs=[
            multi_contour2.SourceSpec(
                name='Base',
                source=yt_observers.ImgTier0Beta2.source,
                slots=[slots.Slot('ImgTier0', tiers.ImgTier0, 'VLA_IMGS_BASE_BETA2', Tag, use_mtn=True),
                       slots.Slot('CbrTier0', tiers.ImgTier0, 'VLA_IMGS_CBIR_BASE_BETA2', Tag, use_mtn=True)],
            ),
            multi_contour2.SourceSpec(
                name='New Runtime',
                source=yt_observers.ImgEmbeddingTier0Beta2.source,
                slots=[
                    slots.Slot('Embedding', tiers.ImgEmbeddingTier0, 'VLA_IMGS_EMBEDDING_BETA', Tag, use_mtn=True),
                    slots.Slot('InvIndex', tiers.ImgInvIndexTier0, 'VLA_IMGS_INVERTED_INDEX_BETA', Tag, use_mtn=True)]
            ),
            multi_contour2.SourceSpec(
                name='Mmeta',
                source=yt_observers.ImgMmetaTier0Beta2.source,
                slots=[slots.Slot('Mmeta', tiers.ImgMmetaTier0, 'VLA_IMGS_MMETA_BETA2', Tag, use_mtn=True)]
            )
        ],
        namespace_prefix='/images/betas/beta2',
    )
    return multi_contour2.make_controller(contour, 'images/betas/beta2/status', readonly)


registry.register('images/betas/beta2', make_controller, [registry.ReportsBackends.V2.vla])
