class DownloadArgs(object):
    def __init__(self, deployer_instances):
        self._hdd_only_hosts = {
            agent.host for agent, spec in deployer_instances.items()
            if 'itag_copy_on_ssd' not in spec['tags']
        }
        self._slow_network_hosts = {
            agent.host for agent, spec in deployer_instances.items()
            if spec['host_resources'].get('net', 0) < 1100  # less then 1Gbit
        }

    def __call__(self, resource, host):
        hdd_only = False
        if host in self._hdd_only_hosts:
            max_dl_speed, io_limit = '16M', '15M'
            hdd_only = True
        elif host in self._slow_network_hosts:
            max_dl_speed, io_limit = '25M', '20M'
        else:
            max_dl_speed, io_limit = '30M', '25M'

        skybone_params = {
            'max_dl_speed': max_dl_speed,
            'hardlink': True,
            'copier_opts': '{direct_write: 1, subproc: 1}',
            'check_policy': {'repeat_sky_get': False},
            'container_params': {'io_limit': '{}: {}'.format(
                '/place' if hdd_only else '/ssd',
                io_limit
            )}
        }

        return skybone_params


class DownloadArgsOld(DownloadArgs):
    def __call__(self, resource, host):
        if host in self._hdd_only_hosts:
            max_dl_speed = '15M'
        elif host in self._slow_network_hosts:
            max_dl_speed = '20M'
        else:
            max_dl_speed = '25M'

        skybone_params = {
            'max_dl_speed': max_dl_speed,
            'hardlink': True,
            'check_policy': {'repeat_sky_get': False},
        }

        return skybone_params
