import infra.callisto.controllers.deployer2.controller as deploy_controller
import infra.callisto.controllers.sdk.registry as registry
import infra.callisto.controllers.sdk.tier as tier
import infra.callisto.controllers.search_source.controller as search_source
import infra.callisto.controllers.slots as slots
import infra.callisto.controllers.utils.gencfg_api as gencfg_api
import infra.callisto.libraries.yt as yt_utils

from infra.callisto.controllers.user.jupiter.chunks.external import Controller as ExternalChunksController
import deploy_params
import tier_chunks

default_topology = 'stable-152-r35'
deployer_groups = [
    ('MAN_IMGS_DEPLOY', default_topology),
]

LOCATION = 'man'


def make_controller(readonly):
    callback = deploy_params.DownloadArgs(
        deployer_instances=gencfg_api.searcher_lookup_agents(*deployer_groups[0], mtn=True),
    )
    deploy_ctrl = deploy_controller.make_controller(deployer_groups, download_args_callback=callback, mtn=True)
    slot_ctrls = search_source.make_slot_controllers(
        slots_(),
        deploy_ctrl,
        deploy_only=True,
        namespace_prefix='/images/prod/',
    )
    slot_ctrls['tier0_chunks_ext'] = ExternalChunksController(
        tier_chunks.location_status(LOCATION),
        tier_chunks.location_target(LOCATION),
        tier=tier.ImgTier0,
        optional=True,
        readonly=readonly
    )
    return search_source.YtDrivenSourceController(
        name='images_prod_man',
        slots_=slot_ctrls,
        deployer=deploy_ctrl,
        target_table=get_yt_target_table(readonly),
        status_table=get_yt_status_table(readonly),
    )


def slots_(topology=default_topology, name_suffix=''):
    return [
        slots.Slot('ImgTier0' + name_suffix, tier.ImgTier0, 'MAN_IMGS_BASE', topology),
        slots.Slot('ImgTier1' + name_suffix, tier.ImgTier1, 'MAN_IMGS_T1_BASE', topology),
        slots.Slot('Embedding', tier.ImgEmbeddingTier0, 'MAN_IMGS_TIER0_EMBEDDING', topology),
        slots.Slot('InvIndex', tier.ImgInvIndexTier0, 'MAN_IMGS_INVERTED_INDEX', topology),
        slots.Slot('ImgMmeta' + name_suffix, tier.ImgMmetaTier0, 'MAN_IMGS_MMETA', topology),
        slots.Slot('ImgMmetaHamster' + name_suffix, tier.ImgMmetaTier0, 'MAN_IMGS_MMETA_HAMSTER', topology),
        slots.Slot('ImgMmetaHeater' + name_suffix, tier.ImgMmetaTier0, 'MAN_IMAGES_HEATER_MMETA', topology),
    ]


def get_yt_target_table(readonly):
    yt_client = yt_utils.create_yt_client('arnold', use_rpc=True)
    return search_source.get_yt_target_table(yt_client, 'images/prod/man/target', readonly)


def get_yt_status_table(readonly):
    yt_client = yt_utils.create_yt_client('arnold', use_rpc=True)
    return search_source.get_yt_status_table(yt_client, 'images/prod/man/status', readonly)


registry.register('images/prod/man', make_controller, [registry.ReportsBackends.V2.man])
