import infra.callisto.controllers.multibeta.controller as controller
import infra.callisto.controllers.multibeta.slots
import infra.callisto.controllers.multibeta.tables as multibeta_tables
import infra.callisto.controllers.sdk.registry as registry
import infra.callisto.controllers.sdk.tier as tiers
import infra.callisto.controllers.utils.gencfg_api as gencfg_api
import infra.callisto.controllers.utils.yp_utils as yp_utils
import infra.callisto.libraries.yt as yt_utils

import configuration
import conf_generator
from .. import oldprod2
import slots
import tables

Tag = 'stable-157-r2918'

MMETA_SLOTS = {
    'img_multibeta{}'.format(i): gencfg_api.GencfgGroup('VLA_IMGS_MULTIBETA{}_MMETA'.format(i), Tag, mtn=False)
    for i in range(1, 10)
}

SLOTS = tuple(MMETA_SLOTS.keys())


DEPLOY_SLOTS = [
    (SLOTS,
     tiers.ImgTier0,
     yp_utils.DeploySlot(yp_utils.YpMasters.vla, 'vla-images-search.vla-images-tier0-base', 20000)),
]
DEPLOY_CBR_SLOTS = [
    (SLOTS,
     tiers.ImgTier0,
     yp_utils.DeploySlot(yp_utils.YpMasters.vla, 'vla-images-search.vla-images-tier0-base', 20100)),
]


def get_configs_table(readonly=True, yt_client=None):
    yt_client = yt_client or yt_utils.create_yt_client('arnold')
    return tables.ConfigsTable(yt_client, '//home/cajuper/user/images/multibeta/configs', readonly)


def get_target_table(readonly=True, yt_client=None):
    yt_client = yt_client or yt_utils.create_yt_client('arnold')
    return multibeta_tables.TargetTable(
        yt_client, '//home/cajuper/user/images/multibeta/base/target',
        configuration.BaseBetaConfiguration, readonly=readonly)


def make_ctrl(readonly):
    yt_client = yt_utils.create_yt_client('arnold')
    yappy_table = tables.YappyTable(yt_client, '//home/yappy/imgs_base_controllers', readonly=True)
    configs_table = get_configs_table(readonly, yt_client=yt_client)
    target_table = get_target_table(readonly, yt_client=yt_client)
    conf_gen = conf_generator.BaseBetaGenerator(
        oldprod2.get_status_table(),
        yappy_table,
        configs_table,
        target_table,
        SLOTS,
    )
    return controller.Ctrl(
        'imgs_multi_beta',
        target_table,
        infra.callisto.controllers.multibeta.slots.SlotsCtrl(
            slots.make_deploy_base_ctrls(DEPLOY_SLOTS) +
            slots.make_deploy_cbir_ctrls(DEPLOY_CBR_SLOTS) +
            slots.make_mmeta_ctrls(MMETA_SLOTS)
        ),
        conf_gen,
        hard_switch=True,
    )


registry.register('images/betas/multi/base', make_ctrl, [registry.ReportsBackends.V2.vla])
