import infra.callisto.controllers.utils.gencfg_api as gencfg_api
import infra.callisto.libraries.yt as yt_utils
import infra.callisto.controllers.sdk.registry as registry

import infra.callisto.controllers.multibeta.controller as controller
import infra.callisto.controllers.multibeta.slots as multibeta_slots
import infra.callisto.controllers.multibeta.tables as multibeta_tables

import conf_generator
import configuration
from .. import oldprod2
import slots
import tables


default_topology = 'stable-157-r2918'

MMETA_SLOTS = {
    'img_multimeta{}'.format(i): gencfg_api.GencfgGroup(
        'VLA_IMGS_MULTIMETA{}_MMETA'.format(i),
        default_topology,
        mtn=False
    )
    for i in range(1, 11)
}

SLOTS = MMETA_SLOTS.keys()


def get_configs_table(readonly=True, yt_client=None):
    yt_client = yt_client or yt_utils.create_yt_client('arnold')
    return tables.ConfigsTable(yt_client, '//home/cajuper/user/images/multibeta/configs', readonly)


def get_target_table(readonly=True, yt_client=None):
    yt_client = yt_client or yt_utils.create_yt_client('arnold')
    return multibeta_tables.TargetTable(
        yt_client, '//home/cajuper/user/images/multibeta/meta/target', configuration.MmetaBetaConfiguration, readonly=readonly,
    )


def make_ctrl(readonly):
    yt_client = yt_utils.create_yt_client('arnold')
    target_table = get_target_table(readonly, yt_client=yt_client)
    conf_gen = conf_generator.MmetaBetaGenerator(
        oldprod2.get_status_table(),
        tables.YappyTable(yt_client, '//home/yappy/imgs_mmeta_controllers', readonly=True),
        get_configs_table(readonly, yt_client),
        target_table,
        SLOTS,
    )
    return controller.Ctrl(
        'imgs_multi_meta',
        target_table,
        multibeta_slots.SlotsCtrl(slots.make_mmeta_ctrls(MMETA_SLOTS)),
        conf_gen,
        hard_switch=True
    )


registry.register('images/betas/multi/meta', make_ctrl, [registry.ReportsBackends.V2.vla])
