import infra.callisto.controllers.multibeta.slots as slots
import infra.callisto.controllers.utils.gencfg_api as gencfg_api
import infra.callisto.controllers.utils.yp_utils as yp_utils

import infra.callisto.protos.multibeta.slot_state_pb2 as slot_state_pb2


class CbrCtrl(slots.BaseCtrl):
    def _generate_configuration_config(self, agent, configuration):
        return {
            'revision': configuration.revision,
            'conf_hash': hash(configuration),
            'container': self._porto_properties,
            'resources': [
                slots.resolve_resource('basesearch.executable', configuration.cbr.executable),
                self._cfg_resource(agent, configuration.cbr),
            ],
        }


class RtyserverCtrl(slots.RtyserverCtrl):
    is_head_slot = True

    def _generate_configuration_config(self, agent, configuration):
        return {
            'revision': configuration.revision,
            'conf_hash': hash(configuration),
            'container': self._porto_properties,
            'index_timestamp': configuration.index_timestamp,
            'resources': [
                slots.resolve_resource('basesearch.executable', configuration.quick_base.executable),
                slots.resolve_resource('basesearch.models', configuration.quick_base.models),
                slots.resolve_resource('basesearch.static_models', configuration.quick_base.static_models),
                slots.resolve_resource('basesearch.cfg', configuration.quick_base.config),
                slots.resolve_resource('basesearch.shardwriter_cfg', configuration.quick_base.shardwriter_config),
            ],
        }

    def instances_proto(self, slot_id, configuration):
        instances = []
        for agent in self._agent_shard_number_map:
            instances.append(slot_state_pb2.InstanceInfo(hostname=agent.host, port=agent.port))
        return instances


class MmetaCtrl(slots.MmetaCompCtrl):
    def _generate_configuration_config(self, agent, configuration):
        config = super(MmetaCtrl, self)._generate_configuration_config(agent, configuration)
        config['resources'].extend(
            self._get_rearrange_resource('mmeta.rearrange_data', configuration.mmeta.rearrange_data) +
            self._get_rearrange_resource('mmeta.rearrange_index', configuration.mmeta.rearrange_index)
        )

        return config

    @staticmethod
    def _get_rearrange_resource(resource_name, resource_id):
        if resource_id == 'default' or not resource_id:
            return []
        return [slots.resolve_resource(resource_name, resource_id)]


def make_deploy_base_ctrls(base_slots, porto_props=None):
    ctrls = []
    for multibeta_slot_ids, tier, deploy_slot in base_slots:
        ctrls.append(slots.BaseCtrl(
            tier,
            yp_utils.agent_shard_number_mapping(
                yp_utils.read_pods(deploy_slot.cluster, deploy_slot.deploy_unit),
                deploy_slot.port, tier
            ),
            multibeta_slot_ids,
            tags={'a_itype_base', deploy_slot.deploy_unit}
        ))

    return ctrls


def make_deploy_cbir_ctrls(base_slots, porto_props=None):
    ctrls = []
    for multibeta_slot_ids, tier, deploy_slot in base_slots:
        ctrls.append(CbrCtrl(
            tier,
            yp_utils.agent_shard_number_mapping(
                yp_utils.read_pods(deploy_slot.cluster, deploy_slot.deploy_unit),
                deploy_slot.port, tier
            ),
            multibeta_slot_ids,
            tags={'a_itype_base', deploy_slot.deploy_unit}
        ))

    return ctrls


def make_base_ctrls(base_slots, porto_props=None):
    return [
        slots.BaseCtrl(
            tier,
            gencfg_api.get_agent_shard_number_mapping([group]),
            slots_ids=list(slots_ids),
            porto_properties=porto_props,
            tags={group.name},
        )
        for slots_ids, descr in base_slots.iteritems() for tier, group in descr.iteritems()
    ]


def make_cbr_ctrls(cbr_slots, porto_props=None):
    return [
        CbrCtrl(
            tier,
            gencfg_api.get_agent_shard_number_mapping([group]),
            slots_ids=list(slots_ids),
            porto_properties=porto_props,
            tags={group.name},
        )
        for slots_ids, descr in cbr_slots.iteritems() for tier, group in descr.iteritems()
    ]


def make_rtyserver_ctrls(rtyserver_slots):
    return [
        RtyserverCtrl(
            tier,
            gencfg_api.get_agent_shard_number_mapping([group]),
            slots_ids=list(slots_ids),
            tags={group.name},
        )
        for slots_ids, descr in rtyserver_slots.iteritems() for tier, group in descr.iteritems()
    ]


def make_mmeta_ctrls(mmeta_slots):
    return [
        MmetaCtrl({
            slot_id: gencfg_api.get_agents([group])
            for slot_id, group in mmeta_slots.iteritems()
        })
    ]
