import infra.callisto.controllers.oldprod.controller as oldprod_controller
import infra.callisto.controllers.oldprod.entities as oldprod_entities
import infra.callisto.controllers.sdk.registry as registry
import infra.callisto.libraries.yt as yt_utils

DB_TIMESTAMP_RESOURCE_TYPE = {
    oldprod_entities.ResourceType(resource_type='IMAGES_PRODUCTION_INDEX_STATE_RESOURCE', task_type=None): 'vars.conf',
}

BASESEARCH_RESOURCE_TYPES = {
    oldprod_entities.ResourceType(resource_type='IMGSEARCH_EXECUTABLE', task_type=None): 'httpsearch',
    oldprod_entities.ResourceType(resource_type='IMAGES_DYNAMIC_MODELS_ARCHIVE', task_type=None): 'models.archive',
}

MIDDLESEARCH_RESOURCE_TYPES = {
    oldprod_entities.ResourceType(resource_type='IMAGES_MIDDLESEARCH_EXECUTABLE', task_type=None): 'httpsearch',
    oldprod_entities.ResourceType(resource_type='IMAGES_MIDDLESEARCH_DYNAMIC_MODELS_ARCHIVE', task_type=None): 'models.archive',
}

QUICK_BASESEARCH_RESOURCE_TYPES = {
    oldprod_entities.ResourceType(resource_type='IMGSEARCH_RTYSERVER_EXECUTABLE', task_type=None): 'httpsearch',
    oldprod_entities.ResourceType(resource_type='IMAGES_DYNAMIC_MODELS_ARCHIVE', task_type=None): 'models.archive',
    oldprod_entities.ResourceType(resource_type='RTYSERVER_MODELS', task_type=None): 'static_models',
    oldprod_entities.ResourceType(resource_type='IMGQUICK_SAAS_RTYSERVER_CONFIGS_BUNDLE', task_type=None): 'config',
    oldprod_entities.ResourceType(resource_type='IMAGES_SHARDWRITER_CONFIG', task_type=None): 'shardwriter_config',
}


def get_yt_client():
    return yt_utils.create_yt_client('arnold', use_rpc=True)


def get_status_table(readonly=True):
    return oldprod_controller.get_yt_status_table(
        get_yt_client(),
        path='//home/cajuper/user/images/prod/oldprod',
        readonly=readonly
    )


def make_controller(readonly=True):
    service_families = [
        oldprod_controller.ServiceFamily('base', BASESEARCH_RESOURCE_TYPES, (
            'sas-images-base-resources',
            # 'man-images-base-resources',
            'vla-images-base-resources',
        )),
        oldprod_controller.ServiceFamily('mmeta', MIDDLESEARCH_RESOURCE_TYPES, (
            'production_imgmmeta_sas',
            # 'production_imgmmeta_man',
            'production_imgmmeta_vla',
        )),
        oldprod_controller.ServiceFamily('quick_base', QUICK_BASESEARCH_RESOURCE_TYPES, (
            'prod-imgs-quick-base-sas',
            # 'prod-imgs-quick-base-man',
            'saas_refresh_production_images_quick_base_vla',
        )),
    ]

    db_checker = oldprod_controller.WebDbChecker(
        oldprod_controller.ServiceFamily('db_timestamp', DB_TIMESTAMP_RESOURCE_TYPE, (
            'sas-images-base-resources',
            # 'man-images-base-resources',
            'vla-images-base-resources',
            'production_imgmmeta_sas',
            # 'production_imgmmeta_man',
            'production_imgmmeta_vla',
        ))
    )
    return oldprod_controller.Controller(
        get_status_table(readonly),
        service_families,
        db_checker
    )


registry.register('images/oldprod2', make_controller, [registry.ReportsBackends.V2.vla])
