import infra.callisto.libraries.yt as yt_utils
import infra.callisto.controllers.slots as slots
import infra.callisto.controllers.search_source.controller as search_source
import infra.callisto.controllers.deployer2.controller as deploy_controller
import infra.callisto.controllers.sdk.tier as tier
import infra.callisto.controllers.utils.gencfg_api as gencfg_api

from yp_location_ctrl import DownloadArgsCallback


def slots_(location, topology):
    return [
        slots.RimSlot('Rim', tier.ImgRIMTier, '{}_IMGS_RIM_3K'.format(location.upper()), topology),
    ]


def get_yt_target_table(location, readonly):
    yt_client = yt_utils.create_yt_client('arnold', use_rpc=True)
    return search_source.get_yt_target_table(yt_client, 'images/prod/rim/{}/target'.format(location), readonly)


def make_controller(location, topology, readonly):
    deployer_groups = (
        ('{}_IMGS_RIM_3K_DEPLOY'.format(location.upper()), topology),
    )

    callback = DownloadArgsCallback(
        deployer_instances=gencfg_api.searcher_lookup_agents(*deployer_groups[0]),
    )
    deploy_ctrl = deploy_controller.make_controller(deployer_groups, download_args_callback=callback, mtn=True)
    slot_ctrls = search_source.make_slot_controllers(
        slots_(location, topology),
        deploy_ctrl,
        deploy_only=True,
        namespace_prefix='/images/prod/rim/',
    )
    return search_source.YtDrivenSourceController(
        name='{}_rim'.format(location),
        slots_=slot_ctrls,
        deployer=deploy_ctrl,
        target_table=get_yt_target_table(location, readonly),
    )
