import infra.callisto.libraries.yt as yt_utils
import infra.callisto.controllers.search_source.controller as search_source
import infra.callisto.controllers.deployer2.controller as deploy_controller
import infra.callisto.controllers.slots as slots
import infra.callisto.controllers.sdk.tier as tier
import infra.callisto.controllers.sdk.registry as registry

from simple_pip_ctrl import SimplePipController


default_topology = 'stable-157-r3336'
deployer_groups = (
    ('VLA_IMGS_RIM_3K_PRIEMKA_DEPLOY', default_topology),
)


def slots_(topology=default_topology):
    return (
        slots.RimSlot('RimPip', tier.ImgRIMTier, 'VLA_IMGS_RIM_3K_PRIEMKA', topology, use_mtn=True),
    )


def get_yt_target_table(readonly):
    yt_client = yt_utils.create_yt_client('arnold', use_rpc=True)
    return search_source.get_yt_target_table(yt_client, '/images/pip/rim/target_v2', readonly)


def make_controller(readonly):
    deploy_ctrl = deploy_controller.make_controller(
        deployer_groups,
        download_args_callback=lambda resource, host: {'max_dl_speed': '120M'},
        mtn=True
    )
    slot_ctrls = search_source.make_slot_controllers(slots_(), deploy_ctrl, namespace_prefix='/images/prod/rim/')
    return SimplePipController(
        name='pip',
        slots_=slot_ctrls,
        deployer=deploy_ctrl,
        target_table=get_yt_target_table(readonly),
    )


registry.register('images/prod/rim/acceptance', make_controller, [registry.ReportsBackends.V2.vla])
